/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.core.ModDataGeneration;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.core.VoidTotemConfig;
import com.affehund.voidtotem.core.network.PacketHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="voidtotem")
public class VoidTotem {
    public static final Logger LOGGER = LogManager.getLogger((String)"Void Totem");
    public static VoidTotem INSTANCE;
    public static final DeferredRegister<Item> ITEMS;
    public static final RegistryObject<Item> VOID_TOTEM_ITEM;

    public VoidTotem() {
        INSTANCE = this;
        LOGGER.debug("Loading up {}...", (Object)"Void Totem");
        if (ModUtils.isModLoaded("curios")) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
            LOGGER.debug("Enqueued IMC to {}", (Object)"curios");
        }
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::gatherData);
        ITEMS.register(modEventBus);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.register((Object)this);
        forgeEventBus.addListener(this::livingFall);
        forgeEventBus.addListener(this::livingHurt);
        forgeEventBus.addListener(this::livingTick);
        forgeEventBus.addGenericListener(ItemStack.class, this::attachCaps);
        PacketHandler.registerMessages();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VoidTotemConfig.COMMON_CONFIG_SPEC, "voidtotem-common.toml");
        LOGGER.debug("{} has finished loading for now!", (Object)"Void Totem");
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack;
        if (ModUtils.isModLoaded("curios") && ModUtils.isVoidTotemOrAdditionalTotem(stack = (ItemStack)event.getObject())) {
            event.addCapability(new ResourceLocation("voidtotem", "curios"), new ICapabilityProvider(){
                final ICurio curio = new ICurio(){

                    public boolean canEquipFromUse(SlotContext slotContext) {
                        return true;
                    }

                    public ItemStack getStack() {
                        return stack;
                    }
                };

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(capability, LazyOptional.of(() -> this.curio));
                }
            });
        }
    }

    @SubscribeEvent
    public void loadLootTables(LootTableLoadEvent event) {
        if (((Boolean)VoidTotemConfig.COMMON_CONFIG.ADD_END_CITY_TREASURE.get()).booleanValue() && event.getName().equals((Object)ModConstants.LOCATION_END_CITY_TREASURE)) {
            LOGGER.debug("Injecting loot table {} from {}", (Object)ModConstants.LOCATION_END_CITY_TREASURE.toString(), (Object)"voidtotem");
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ModConstants.LOCATION_END_CITY_TREASURE_INJECTION)).name("voidtotem_injection").m_79082_());
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new ModDataGeneration.AdvancementGen(generator, existingFileHelper));
            ModDataGeneration.BlockTagsGen blockTagsProvider = new ModDataGeneration.BlockTagsGen(generator, "voidtotem", existingFileHelper);
            generator.m_123914_((DataProvider)new ModDataGeneration.ItemTagsGen(generator, blockTagsProvider, "voidtotem", existingFileHelper));
            generator.m_123914_((DataProvider)new ModDataGeneration.LootTableGen(generator));
            generator.m_123914_((DataProvider)new ModDataGeneration.RecipeGen(generator));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new ModDataGeneration.LanguageGen(generator, "de_de"));
            generator.m_123914_((DataProvider)new ModDataGeneration.LanguageGen(generator, "en_us"));
            generator.m_123914_((DataProvider)new ModDataGeneration.ItemModelGen(generator, "voidtotem", existingFileHelper));
        }
    }

    private void livingFall(LivingFallEvent event) {
        LivingEntity livingEntity;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getPersistentData().m_128471_("Void TotemIsFallDamageImmune")) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.f_8906_.f_9737_ = 0;
            }
            event.setDamageMultiplier(0.0f);
            livingEntity.getPersistentData().m_128379_("Void TotemIsFallDamageImmune", false);
            event.setCanceled(true);
        }
    }

    private void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        ModUtils.setLastSaveBlockPos(livingEntity);
        ModUtils.resetFallDamageImmunity(livingEntity);
    }

    private void livingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (event.getAmount() >= livingEntity.m_21223_() && ModUtils.tryUseVoidTotem(livingEntity, event.getSource())) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void tooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (ModUtils.isVoidTotemOrAdditionalTotem(stack) && ((Boolean)VoidTotemConfig.COMMON_CONFIG.SHOW_TOTEM_TOOLTIP.get()).booleanValue()) {
            event.getToolTip().add(new TranslatableComponent("tooltip.voidtotem.totem_of_void_undying").m_130940_(ChatFormatting.GREEN));
        }
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"voidtotem");
        VOID_TOTEM_ITEM = ITEMS.register("totem_of_void_undying", () -> new Item(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40757_).m_41497_(Rarity.UNCOMMON)));
    }
}

